<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:32.194702079 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-X3" />
    <supported-cpuid id="Cortex-A715" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexA715CPU_CYCLES &gt; 0), min(($BackendBoundCortexA715STALL_SLOT_BACKEND / (5 * $BackendBoundCortexA715CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of cache" expression="if(($BackendMemoryBoundCortexA715STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexA715STALL_BACKEND_MEM / $BackendMemoryBoundCortexA715STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA715CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA715STALL_BACKEND / $BackendStalledCyclesCortexA715CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Barrier Operations Percentage">
        <series color="19,148,180" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA715INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA715ISB_SPEC + $BarrierOperationsPercentageCortexA715DSB_SPEC) + $BarrierOperationsPercentageCortexA715DMB_SPEC) / $BarrierOperationsPercentageCortexA715INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Misprediction Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA715BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA715BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA715BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA715INST_RETIRED &gt; 0), (($BranchMPKICortexA715BR_MIS_PRED_RETIRED / $BranchMPKICortexA715INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA715INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA715BR_IMMED_SPEC + $BranchOperationsPercentageCortexA715BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA715INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexA715INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexA715CPU_CYCLES / $CyclesPerInstructionCortexA715INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA715INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA715CRYPTO_SPEC / $CryptoOperationsPercentageCortexA715INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB MPKI">
        <series color="19,148,180" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA715INST_RETIRED &gt; 0), (($DTLBMPKICortexA715DTLB_WALK / $DTLBMPKICortexA715INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA715L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA715DTLB_WALK / $DTLBWalkPercentageCortexA715L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Half Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexA715INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexA715FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexA715INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Single Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexA715INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexA715FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexA715INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Double Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexA715INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexA715FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexA715INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by any instruction. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($FloatingPointOperationsPerCycleCortexA715CPU_CYCLES &gt; 0), (($FloatingPointOperationsPerCycleCortexA715FP_SCALE_OPS_SPEC + $FloatingPointOperationsPerCycleCortexA715FP_FIXED_OPS_SPEC) / $FloatingPointOperationsPerCycleCortexA715CPU_CYCLES), 0)" name="Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA715CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA715STALL_FRONTEND / $FrontendStalledCyclesCortexA715CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA715INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA715DP_SPEC - $IntegerOperationsPercentageCortexA715DSB_SPEC) / $IntegerOperationsPercentageCortexA715INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA715CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA715INST_RETIRED / $InstructionsPerCycleCortexA715CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB MPKI">
        <series color="19,148,180" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA715INST_RETIRED &gt; 0), (($ITLBMPKICortexA715ITLB_WALK / $ITLBMPKICortexA715INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA715L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA715ITLB_WALK / $ITLBWalkPercentageCortexA715L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKICortexA715INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKICortexA715L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKICortexA715L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKICortexA715INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA715L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA715L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA715L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA715INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA715L1D_CACHE_REFILL / $L1DCacheMPKICortexA715INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA715L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA715L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA715L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA715INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA715L1D_TLB_REFILL / $L1DataTLBMPKICortexA715INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA715L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA715L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA715L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA715INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA715L1I_CACHE_REFILL / $L1ICacheMPKICortexA715INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA715L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA715L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA715L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA715INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA715L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA715INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA715L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA715L2D_CACHE_REFILL / $L2CacheMissPercentageCortexA715L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA715INST_RETIRED &gt; 0), (($L2CacheMPKICortexA715L2D_CACHE_REFILL / $L2CacheMPKICortexA715INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA715L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA715L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA715L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA715INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA715L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA715INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data demand accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheDemandMPKICortexA715INST_RETIRED &gt; 0), ((($L2DCacheDemandMPKICortexA715L2D_CACHE_REFILL_RD + $L2DCacheDemandMPKICortexA715L2D_CACHE_REFILL_WR) / $L2DCacheDemandMPKICortexA715INST_RETIRED) * 1000), 0)" name="L2D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageCortexA715L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageCortexA715L2D_CACHE_REFILL / $L2DCacheMissPercentageCortexA715L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKICortexA715INST_RETIRED &gt; 0), (($L2DCacheMPKICortexA715L2D_CACHE_REFILL / $L2DCacheMPKICortexA715INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA715L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexA715L3D_CACHE_REFILL / $L3CacheMissPercentageCortexA715L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA715INST_RETIRED &gt; 0), (($L3CacheMPKICortexA715L3D_CACHE_REFILL / $L3CacheMPKICortexA715INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexA715INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexA715LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexA715INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA715LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA715LL_CACHE_RD - $LLCacheReadHitPercentageCortexA715LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA715LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA715LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA715LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA715LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA715INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA715LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA715INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA715INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA715LD_SPEC / $LoadOperationsPercentageCortexA715INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Non-SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by an instruction that is not an SVE instruction. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($NonSVEFloatingPointOperationsPerCycleCortexA715CPU_CYCLES &gt; 0), ($NonSVEFloatingPointOperationsPerCycleCortexA715FP_FIXED_OPS_SPEC / $NonSVEFloatingPointOperationsPerCycleCortexA715CPU_CYCLES), 0)" name="Non-SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Acquire Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexA715INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexA715RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexA715INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Release Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexA715INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexA715RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexA715INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Operations Percentage">
        <series color="19,148,180" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexA715OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexA715OP_RETIRED / $RetiredOperationsPercentageCortexA715OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retiring">
        <series color="19,148,180" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexA715CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexA715OP_SPEC &gt; 0), min(((1 - ($RetiringCortexA715STALL_SLOT / ($RetiringCortexA715CPU_CYCLES * 5))) * ($RetiringCortexA715OP_RETIRED / $RetiringCortexA715OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA715INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA715VFP_SPEC / $FloatingPointOperationsPercentageCortexA715INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA715INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA715ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA715INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA715INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA715ST_SPEC / $StoreOperationsPercentageCortexA715INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKICortexA715INST_SPEC &gt; 0), (($StoreExclusiveFailuresPKICortexA715STREX_FAIL_SPEC / $StoreExclusiveFailuresPKICortexA715INST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Failures Percentage">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed as a percentage of store-exclusive instructions speculatively executed" expression="if(($StoreExclusiveFailuresPercentageCortexA715STREX_SPEC &gt; 0), min(($StoreExclusiveFailuresPercentageCortexA715STREX_FAIL_SPEC / $StoreExclusiveFailuresPercentageCortexA715STREX_SPEC), 1), 0)" name="Store-Exclusive Failures Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexA715INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexA715STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexA715INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Operations (Load/Store Inclusive) Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageCortexA715INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageCortexA715SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageCortexA715INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by SVE instructions. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($SVEFloatingPointOperationsPerCycleCortexA715CPU_CYCLES &gt; 0), ($SVEFloatingPointOperationsPerCycleCortexA715FP_SCALE_OPS_SPEC / $SVEFloatingPointOperationsPerCycleCortexA715CPU_CYCLES), 0)" name="SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Empty Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with no active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEEmptyPredicatePercentageCortexA715SVE_PRED_SPEC &gt; 0), min(($SVEEmptyPredicatePercentageCortexA715SVE_PRED_EMPTY_SPEC / $SVEEmptyPredicatePercentageCortexA715SVE_PRED_SPEC), 1), 0)" name="SVE Empty Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Full Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with all active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEFullPredicatePercentageCortexA715SVE_PRED_SPEC &gt; 0), min(($SVEFullPredicatePercentageCortexA715SVE_PRED_FULL_SPEC / $SVEFullPredicatePercentageCortexA715SVE_PRED_SPEC), 1), 0)" name="SVE Full Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Partial Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with at least one active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEPartialPredicatePercentageCortexA715SVE_PRED_SPEC &gt; 0), min(($SVEPartialPredicatePercentageCortexA715SVE_PRED_PARTIAL_SPEC / $SVEPartialPredicatePercentageCortexA715SVE_PRED_SPEC), 1), 0)" name="SVE Partial Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with predicates as a percentage of operations speculatively executed" expression="if(($SVEPredicatePercentageCortexA715INST_SPEC &gt; 0), min(($SVEPredicatePercentageCortexA715SVE_PRED_SPEC / $SVEPredicatePercentageCortexA715INST_SPEC), 1), 0)" name="SVE Predicate Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv9_Cortex_A715_metric_backend_bound" />
    <select-metric id="ARMv9_Cortex_A715_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Cortex_A715_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A715_metric_barrier_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_branch_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_branch_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_cpi" />
    <select-metric id="ARMv9_Cortex_A715_metric_crypto_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_fp16_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_fp32_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_fp64_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_fp_ops_per_cycle" />
    <select-metric id="ARMv9_Cortex_A715_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_A715_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_ipc" />
    <select-metric id="ARMv9_Cortex_A715_metric_itlb_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l2d_cache_demand_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l2d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_ldrex_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Cortex_A715_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_load_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_nonsve_fp_ops_per_cycle" />
    <select-metric id="ARMv9_Cortex_A715_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Cortex_A715_metric_retiring" />
    <select-metric id="ARMv9_Cortex_A715_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_simd_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_store_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_strex_fail_mpki" />
    <select-metric id="ARMv9_Cortex_A715_metric_strex_fail_percent" />
    <select-metric id="ARMv9_Cortex_A715_metric_strex_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_sve_all_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_sve_fp_ops_per_cycle" />
    <select-metric id="ARMv9_Cortex_A715_metric_sve_predicate_empty_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_sve_predicate_full_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_sve_predicate_partial_percentage" />
    <select-metric id="ARMv9_Cortex_A715_metric_sve_predicate_percentage" />
</template>
